package com.kpl.CourierMgmt.CourierManager;

import java.time.Duration;

import com.kpl.CourierMgmt.GoogleMapClient.IGoogleMapApi;
import com.kpl.CourierMgmt.GoogleMapClient.IGoogleRoute;

public class FakeGoogleMapper implements IGoogleMapApi {

	@Override
	public IGoogleRoute GetRoute(String origin, String destination) {
        if (isStringNullOrWhiteSpace(origin))
            throw new IllegalArgumentException("Route origin is empty");
        if (isStringNullOrWhiteSpace(destination))
            throw new IllegalArgumentException("Route destination is empty");

        // Deal with the non-journey

        if (origin.equalsIgnoreCase(destination))
            return new FakeGoogleRoute(destination, origin, 0.0, 0);

        // Handle real journeys

        for(IGoogleRoute r : FakeGoogleRoute.Routes)
        	if(r.GetOrigin().equalsIgnoreCase(origin) && r.GetDestination().equalsIgnoreCase(destination))
        		return r;
        return null;
    }
	
	public static boolean isStringNullOrWhiteSpace(String value) {
	    if (value == null) {
	        return true;
	    }

	    for (int i = 0; i < value.length(); i++) {
	        if (!Character.isWhitespace(value.charAt(i))) {
	            return false;
	        }
	    }

	    return true;
	}
}
