package com.kpl.CourierMgmt.GoogleMapClient;
import java.time.Duration;

public interface IGoogleRoute {
	/// <summary>
    /// Error code. "OK" if valid route found. Other if not.
    /// </summary>

    String GetStatus();

    /// <summary>
    /// The starting point for the journey, as
    /// normalised and filled in by Google maps
    /// </summary>

    String GetOrigin();

    /// <summary>
    /// The destination for the journey, as
    /// normalised and filled in by Google maps
    /// </summary>

    String GetDestination();

    /// <summary>
    /// Total route distance between origin
    /// and destination in kilometres
    /// </summary>

    double GetDistance();

    /// <summary>
    /// The anticipated duration of the journey
    /// if it were to be carries out right now
    /// </summary>

    Duration GetDuration();
}
