package com.kpl.CourierMgmt.CourierManager;

public class BasicPremiumCalculator implements IPremiumCalculator {

	@Override
	public int CalculatePremium(HazardType hazardType, int packageValue, double distance, double weight)
    {
        // Validate arguments

        if (packageValue < 0)
            throw new IllegalArgumentException("Package cannot have a negative value");
        if (distance <= 0 || weight <= 0)
            throw new IllegalArgumentException("Package must have a realistic weight and journey distance");

        // Insurance and provision of an escort for
        // a package priced at 3% of the item's value
        // for items at or over 100 dollars or euros

        int premium = 0;
        if(packageValue >= 10000)
            premium = (int)(0.5 + packageValue * 0.03);

        // Hazardous materials have an additional premium of 10 dollars or euros
        // plus 1 dollar or euro per km per kg, regardless of the hazard type

        if (hazardType != HazardType.NonHazardous)
            premium += 1000 + (int)(0.5 + 100 * distance * weight);
        return premium;
    }
}
