package com.kpl.CourierMgmt.CourierManager;

import com.kpl.CourierMgmt.GoogleMapClient.IGoogleMapApi;
import com.kpl.CourierMgmt.GoogleMapClient.IGoogleRoute;

public class MockGoogleMapApi implements IGoogleMapApi {
	String expectedOrigin;
    String expectedDestination;
    int numberOfCalls;
    int expectedNumberOfCalls;
    IGoogleRoute returnedRoute;
    boolean argumentsHaveCorrectValues;

    public MockGoogleMapApi(IGoogleRoute returnedRoute, String expOrg, String expDest, int expNumCalls)
    {
        this.returnedRoute = returnedRoute;
        expectedOrigin = expOrg;
        expectedDestination = expDest;
        expectedNumberOfCalls = expNumCalls;
        numberOfCalls = 0;
        argumentsHaveCorrectValues = false;
    }

    @Override
	public IGoogleRoute GetRoute(String origin, String destination) {
        numberOfCalls++;
        argumentsHaveCorrectValues =
            expectedOrigin == origin
            && expectedDestination == destination;
        return returnedRoute;
    }

    public boolean ExpectationsHaveBeenMet()
    {
        return numberOfCalls == expectedNumberOfCalls
            && argumentsHaveCorrectValues;
    }
}
