/*
 * Decompiled with CFR 0.152.
 */
package com.kpl.CourierMgmt.CourierManager;

import com.kpl.CourierMgmt.CourierManager.CourierBooking;
import com.kpl.CourierMgmt.GoogleMapClient.IGoogleMapApi;
import com.kpl.CourierMgmt.GoogleMapClient.IGoogleRoute;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class Courier {
    private IGoogleMapApi mapApi;
    public List<CourierBooking> Schedule = new ArrayList<CourierBooking>();
    public String Name;
    public String InitialLocation;
    public Date TimeAtLocation;

    public String GetLocationWhenNextFree() {
        if (this.Schedule == null || this.Schedule.size() <= 0) {
            return this.InitialLocation;
        }
        return this.Schedule.get(this.Schedule.size() - 1).GetDestination();
    }

    public Instant GetTimeWhenNextFree() {
        if (this.Schedule == null || this.Schedule.size() == 0) {
            return Instant.now();
        }
        return this.Schedule.get(this.Schedule.size() - 1).GetEstimatedDropOffTime().plus(CourierBooking.DropOffWaitingTime);
    }

    public Courier(IGoogleMapApi gma, String name, String location) {
        this.mapApi = gma;
        this.Name = name;
        this.InitialLocation = location;
        this.TimeAtLocation = new Date();
    }

    public Instant CouldArriveAt(IGoogleMapApi mapApi, String location) {
        if (this.GetLocationWhenNextFree().equalsIgnoreCase(location)) {
            return this.GetTimeWhenNextFree();
        }
        IGoogleRoute route = mapApi.GetRoute(this.GetLocationWhenNextFree(), location);
        if (route.GetStatus() == "OK") {
            return this.GetTimeWhenNextFree().plus(route.GetDuration());
        }
        throw new IllegalArgumentException("Route not found: " + route.GetStatus());
    }

    public void TakeBooking(CourierBooking booking) {
        IGoogleRoute pickupRoute = this.mapApi.GetRoute(this.GetLocationWhenNextFree(), booking.Route.GetOrigin());
        if (pickupRoute.GetStatus() != "OK") {
            throw new IllegalArgumentException("Courier unable to take assigned booking");
        }
        booking.EstimatedPickupTime = this.GetTimeWhenNextFree().plus(pickupRoute.GetDuration());
        booking.PickupRoute = pickupRoute;
        this.Schedule.add(booking);
    }

    public String toString() {
        return String.valueOf(this.GetLocationWhenNextFree()) + " @ " + this.GetTimeWhenNextFree();
    }
}

